package editor;

import game.BulletSprite;
import game.CustomImageData;
import game.CustomImageDataII;
import game.PlayingWithCosine;
import game.PonyPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;

public class PlayerCharacterEditorPanel extends JPanel implements Runnable {
	
	private PlayerCharacterStatPanel statPanel;
	private PlayerCharacterAnimationDirectionPanel leftAnimPanel;
	private PlayerCharacterAnimationDirectionPanel rightAnimPanel;
	private CustomAnimationPanel bulletPanel;
	
	private BufferedImage noPreviewImage;
	private BufferedImage currentImage = null;
	private boolean facingLeft = false;
	private boolean justSwitchedCharacterImage = false;
	
	private BulletStatPanel bulletStatPanel;
	
	private JDialog parent;
	
	private boolean wasCancelled = false;
	
	private String contentArray[] = null;
	
	
	public PlayerCharacterEditorPanel (JDialog theParent)  {
		
		this.parent = theParent;
		
		
		
		this.setLayout(new BorderLayout());
		
		try {
			noPreviewImage = ImageIO.read(CustomAnimationPanel.class.getResource("/images/no_preview_available.GIF"));
		} catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Error while trying to load the \"no preview\" image!");
		}
		
		JTabbedPane mainPanel = new JTabbedPane();
		
		
		statPanel = new PlayerCharacterStatPanel(this, theParent, 30, 30, 22, 4, 4, Color.white, Color.black, null, "Name here");
		mainPanel.addTab("Character Stats", statPanel);
		
		leftAnimPanel = new PlayerCharacterAnimationDirectionPanel(theParent, "Left", null, null, null);
		mainPanel.addTab("Left Img", leftAnimPanel);
		
		rightAnimPanel = new PlayerCharacterAnimationDirectionPanel(theParent, "Right", null, null, null);
		mainPanel.addTab("Right Img", rightAnimPanel);
		
		bulletPanel = new CustomAnimationPanel(theParent, "Bullet", "Bullet", false);
		mainPanel.addTab("Bullet Img", bulletPanel);
		
		bulletStatPanel = new BulletStatPanel(theParent, this, 11, 9, false, false, 4);
		mainPanel.addTab("Bullet Stats", bulletStatPanel);
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel bottomPanel = new JPanel(new GridLayout(1, 3));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				wasCancelled = true;
				parent.setVisible(false);
				parent.dispose();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				contentArray = getFieldSummary();
				
//				StringBuffer sb = new StringBuffer("<html>A list of the strings: <br><br>");
//				for(String s : strArray) {
//					sb.append(s);
//					sb.append("<br>");
//				}
//				
//				sb.append("<br>That is all.</html>");
//				
//				JOptionPane.showMessageDialog(null, sb.toString());
				
				wasCancelled = false;
				
				parent.setVisible(false);
				parent.dispose();
				
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		
		this.setPreferredSize(new Dimension(500, 600));
		
		Thread t = new Thread(this);
		t.start();
	}
	

	public PlayerCharacterEditorPanel (JDialog theParent, String theContentArray[])  {
		
		this.parent = theParent;
		
//		if(theContentArray != null) {
//			System.out.println("<><>DELME  *******  size of theContentArray is: " + theContentArray);
//			for(String s : theContentArray) {
//				System.out.println("<><>DELME  *******  S: " + s);
//			}
//		}
		
		int theHitboxWidth = 30;
		int theHitBoxHeight = 30;
		int theYOffset = 22;
		String theCharName = "Name here";
		int theSpeed = 4;
		int theHealth = 4;
		Color theFaceplateTextColor = Color.black;
		Color theFaceplateBgColor = Color.white;
		String theFaceplateImage = null;
		
		String theLeftStandAnim[] = null;
		
		String theLeftWalkAnim[] = null;
		
		String theLeftAirAnim[] = null;
		
		String theRightStandAnim[] = null;
		
		String theRightWalkAnim[] = null;
		
		String theRightAirAnim[] = null;
		
		String theBulletAnim[] = null;
		
		int theAttack = 4;
		boolean theSpread = false;
		boolean theMedic = false;
		
		
		int theBulletSpawnXOffset = 11;
		int theBulletSpawnYOffset = 11;
		
		//dig it out of the array here
		
		if(theContentArray != null) {
			for(int i = 0; i < theContentArray.length; i++) {
				
//				System.out.println("<><>DELME [[[[[[  at the start of the loop; what's in theContentArray[i]? " + theContentArray[i]);
				
				String s = theContentArray[i];
				
				if(s.contains("HitBoxWidth:")) {
					try {
						theHitboxWidth = Integer.parseInt(s.substring(12).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("HitBoxHeight:")) {
					try {
						theHitBoxHeight = Integer.parseInt(s.substring(13).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("HitBoxYOffset:")) {
					try {
						theYOffset = Integer.parseInt(s.substring(14).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("CharName:")) {
					theCharName = s.substring(9).trim();
				} else if(s.contains("Speed:")) {
					try {
						theSpeed = Integer.parseInt(s.substring(6).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("Health:")) {
					try {
						theHealth = Integer.parseInt(s.substring(7).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("FaceplateTextColor:")) {
					theFaceplateTextColor = CustomAnimationPanel.convertStringToColor(s.substring(19));
				} else if(s.contains("FaceplateBgColor:")) {
					theFaceplateBgColor = CustomAnimationPanel.convertStringToColor(s.substring(17));
				} else if(s.contains("FaceplateImage:")) {
					theFaceplateImage = s.substring(15);
				} else if(s.contains("LeftStandAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(14).trim());
						
						if(countOfItems == 0)
							continue;
						
//						System.out.println("<><>DELME countOfItems is: " + countOfItems);
						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
//							System.out.println("<><>DELME %%%%%%%%% now adding this to the array for the left stand animation: " + theContentArray[i]);
							tempList.add(theContentArray[i++]);
						}
						
						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theLeftStandAnim = tempList.toArray(new String[0]);
						
//						System.out.println("<><>DELME %%%% theLeftStandAnim's length: " + theLeftStandAnim.length);
//						for(String sss : theLeftStandAnim) {
//							System.out.println("<><>DELME %%%%% contains: " + sss);
//						}
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn LeftStandAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("LeftWalkAnim:")) {
					
//					System.out.println("<><>DELME ~~~~~ found LeftWalkAnim:!");
					
					try {
						int countOfItems = Integer.parseInt(s.substring(13).trim());

						i++;
						
//						System.out.println("<><>DELME ~~~~~~~ ahoy!  found this for the (FRST) left walk animation: " + theContentArray[i]);
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
//							System.out.println("<><>DELME ~~~~~~~ ahoy!  found this for the (LEFT) left walk animation: " + theContentArray[i]);
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theLeftWalkAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn LeftWalkAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("LeftAirAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(12).trim());

						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theLeftAirAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn LeftAirAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightStandAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(15).trim());

						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theRightStandAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn RightStandAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightWalkAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(14).trim());

						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theRightWalkAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn RightWalkAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightAirAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(13).trim());

						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theRightAirAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn RightAirAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("BulletAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(11).trim());

						i++;
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < theContentArray.length && j < countOfItems; j++) {
							tempList.add(theContentArray[i++]);
						}

						i--; //don't want to increment it too far, and we will if we aren't careful, here
						
						theBulletAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to turn BulletAnim into a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("Attack:")) {
					try {
						theAttack = Integer.parseInt(s.substring(7).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("NoSpread")) {
					theSpread = false;
				} else if(s.contains("Spread")) {
					theSpread = true;
				} else if(s.contains("NoMedic")) {
					theMedic = false;
				} else if(s.contains("Medic")) {
					theMedic = true;
				} else if(s.contains("BulletSpawnXOffset:")) {
					try {
						theBulletSpawnXOffset = Integer.parseInt(s.substring(19).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("BulletSpawnYOffset:")) {
					try {
						theBulletSpawnYOffset = Integer.parseInt(s.substring(19).trim());
					} catch(NumberFormatException e) {}
				}
				
				
			}
		}
		
		
		
		
//		System.out.println("<><>DELME theLeftAirAnim" + (theLeftAirAnim == null));
//		System.out.println("<><>DELME theLeftStandAnim" + (theLeftStandAnim == null));
//		System.out.println("<><>DELME theLeftWalkAnim" + (theLeftWalkAnim == null));
//		
//		System.out.println("<><>DELME theRightAirAnim" + (theRightAirAnim == null));
//		System.out.println("<><>DELME theRightStandAnim" + (theRightStandAnim == null));
//		System.out.println("<><>DELME theRightWalkAnim" + (theRightWalkAnim == null));
		
		
		
		
		
		this.setLayout(new BorderLayout());
		
		try {
			noPreviewImage = ImageIO.read(CustomAnimationPanel.class.getResource("/images/no_preview_available.GIF"));
		} catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Error while trying to load the \"no preview\" image!");
		}
		
		JTabbedPane mainPanel = new JTabbedPane();
		
		statPanel = new PlayerCharacterStatPanel(this, theParent,
				 theHitboxWidth,
				 theHitBoxHeight,
				 theYOffset,
				 theHealth,
				 theSpeed,
				 theFaceplateBgColor,
				 theFaceplateTextColor,
				 theFaceplateImage,
				 theCharName);
		mainPanel.addTab("Character Stats", statPanel);
		
		leftAnimPanel = new PlayerCharacterAnimationDirectionPanel(theParent, "Left", theLeftStandAnim, theLeftWalkAnim, theLeftAirAnim);
		mainPanel.addTab("Left Img", leftAnimPanel);
		
		rightAnimPanel = new PlayerCharacterAnimationDirectionPanel(theParent, "Right", theRightStandAnim, theRightWalkAnim, theRightAirAnim);
		mainPanel.addTab("Right Img", rightAnimPanel);
		
		if(theBulletAnim != null) {
			bulletPanel = new CustomAnimationPanel(theParent, "Bullet", "Bullet", convertStringArrayToAnimation(theBulletAnim, theParent), false);
		} else {
			bulletPanel = new CustomAnimationPanel(theParent, "Bullet", "Bullet", false);
		}
		mainPanel.addTab("Bullet Img", bulletPanel);
		
		bulletStatPanel = new BulletStatPanel(theParent, this, theBulletSpawnXOffset, theBulletSpawnYOffset, theMedic, theSpread, theAttack);
		mainPanel.addTab("Bullet Stats", bulletStatPanel);
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel bottomPanel = new JPanel(new GridLayout(1, 3));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				wasCancelled = true;
				parent.setVisible(false);
				parent.dispose();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
//				JOptionPane.showMessageDialog(null, "<><>DELME second one");
				
				contentArray = getFieldSummary();
				
				
//				StringBuffer sb = new StringBuffer("<html>A list of the strings: <br><br>");
//				for(String s : strArray) {
//					sb.append(s);
//					sb.append("<br>");
//				}
//				
//				sb.append("<br>That is all.</html>");
//				
//				JOptionPane.showMessageDialog(null, sb.toString());
				
				wasCancelled = false;
				
				parent.setVisible(false);
				parent.dispose();
				
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		
		this.setPreferredSize(new Dimension(500, 600));
		
		Thread t = new Thread(this);
		t.start();
	}
	
	
	public static CustomImageDataII [] convertStringArrayToAnimation(String [] strArray, ImageObserver io) {
		
		ArrayList<CustomImageDataII> returnValue = new ArrayList<CustomImageDataII>();
		
		for(String s : strArray) {
			returnValue.add(convertStringToImage(s, io));
		}
		
		
		return returnValue.toArray(new CustomImageDataII[0]);
	}
	
	public static CustomImageDataII convertStringToImage(String str, ImageObserver io) {
		
		String arr[] = str.split("\\*");
		Color transpColor = null;
		if(arr.length > 1)
			transpColor = CustomImageData.translateFileInStringToColor(arr[1]);
		
		CustomImageDataII returnValue = new CustomImageDataII(new File(arr[0]), transpColor, io);
		
//		System.out.println("<><>DELME returnValue's filename: " + returnValue.getFileName() + ", and the String what went in: " + str);
//		if(returnValue.getFileName() == null) {
//			System.out.println("<><>DELME that's my cue to quit!");
//			System.exit(0);
//		}
		
		return returnValue;
	}
	
	
	public class PlayerCharacterAnimationDirectionPanel extends JTabbedPane {
		
		private CustomAnimationPanel walkAnimPanel;
		private CustomAnimationPanel standAnimPanel;
		private CustomAnimationPanel airAnimPanel;
		
		public PlayerCharacterAnimationDirectionPanel(JDialog theParent, String theDirection, String [] standAnimStr, String [] walkAnimStr, String [] airAnimStr) {
			
			if(standAnimStr != null) {
				standAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Stand Animation", theDirection + " Stand Animation", convertStringArrayToAnimation(standAnimStr, theParent), false);
			} else {
				standAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Stand Animation", theDirection + " Stand Animation", false);
			}
			
			if(walkAnimStr != null) {
				walkAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Walk Animation", theDirection + " Walk Animation", convertStringArrayToAnimation(walkAnimStr, theParent), false);
			} else {
				walkAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Walk Animation", theDirection + " Walk Animation", false);
			}

			if(airAnimStr != null) {
				airAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Air Animation", theDirection + " Air Animation", convertStringArrayToAnimation(airAnimStr, theParent), false);
			} else {
				airAnimPanel = new CustomAnimationPanel(theParent, theDirection + " Air Animation", theDirection + " Air Animation", false);
			}
			
			this.addTab("Stand Animation", standAnimPanel);
			this.addTab("Walk Animation", walkAnimPanel);
			this.addTab("Air Animation", airAnimPanel);
			
		}

		public CustomAnimationPanel getWalkAnimPanel() {
			return walkAnimPanel;
		}

		public CustomAnimationPanel getStandAnimPanel() {
			return standAnimPanel;
		}

		public CustomAnimationPanel getAirAnimPanel() {
			return airAnimPanel;
		}
		
	}
	
	public class PlayerCharacterStatPanel extends JPanel {
		
		private JTextArea hitboxWidth;
		private JTextArea hitboxHeight;
		private JTextArea hitboxYOffset;
		
		private JTextArea name;
		private JTextArea speed;
		private JTextArea health;
//		private JTextArea attack;
		
//		private JCheckBox spreadShots;
//		private JCheckBox medic;
		
		private PlayerCharacterEditorPanel parent;
		private JDialog grandParent;
		
		private MiniColorCanvas backgroundColorCanvas = null;
		private MiniColorCanvas textColorCanvas = null;
		
		private FaceplatePreviewCanvas facePreview;
		
		
		public PlayerCharacterStatPanel(
				PlayerCharacterEditorPanel theParent, 
				JDialog theGrandParent,
				int theHitboxWidth,
				int theHitboxHeight,
				int theYOffset,
				int theHealth,
				int theSpeed,
				Color theBgColor,
				Color theTextColor,
				String theFaceplateImage,
				String theCharName) {
			
			parent = theParent;
			grandParent = theGrandParent;
			
			this.setLayout(new GridLayout(2, 1));
			
			JPanel topPanel = new JPanel(new GridLayout(1, 2));
			
			PlayerCharacterPreviewCanvas previewCanvas = new PlayerCharacterPreviewCanvas(theGrandParent, theParent);
			topPanel.add(previewCanvas);
			
			JPanel hitboxControlPanel = new JPanel(new GridLayout(3, 1));
			
			JPanel hitboxWidthPanel = new JPanel(new FlowLayout());
			JLabel hitboxWidthLabel = new JLabel("Hitbox Width:");
			hitboxWidth = new JTextArea(Integer.toString(theHitboxWidth));
			hitboxWidth.setPreferredSize(new Dimension(60, 21));
			hitboxWidth.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			hitboxWidthPanel.add(hitboxWidthLabel);
			hitboxWidthPanel.add(hitboxWidth);
			
			hitboxControlPanel.add(hitboxWidthPanel);
			
			
			
			JPanel hitboxHeightPanel = new JPanel(new FlowLayout());
			JLabel hitboxHeightLabel = new JLabel("Hitbox Height:");
			hitboxHeight = new JTextArea(Integer.toString(theHitboxHeight));
			hitboxHeight.setPreferredSize(new Dimension(60, 21));
			hitboxHeight.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			hitboxHeightPanel.add(hitboxHeightLabel);
			hitboxHeightPanel.add(hitboxHeight);
			
			hitboxControlPanel.add(hitboxHeightPanel);
			
			
			
			JPanel hitboxYOffsetPanel = new JPanel(new FlowLayout());
			JLabel hitboxYOffsetLabel = new JLabel("Hitbox YOffset:");
			hitboxYOffset = new JTextArea(Integer.toString(theYOffset));
			hitboxYOffset.setPreferredSize(new Dimension(60, 21));
			hitboxYOffset.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			hitboxYOffsetPanel.add(hitboxYOffsetLabel);
			hitboxYOffsetPanel.add(hitboxYOffset);
			
			hitboxControlPanel.add(hitboxYOffsetPanel);
			
			
			topPanel.add(hitboxControlPanel);
			
			
			this.add(topPanel);
			
			
			JPanel bottomPanel = new JPanel(new GridLayout(1, 2));
			
			
			JPanel bottomLeftPanel = new JPanel(new BorderLayout());
			
			JPanel namePanel = new JPanel(new FlowLayout());
			namePanel.setBorder(BorderFactory.createTitledBorder("Character Name"));
			name = new JTextArea(theCharName);
			name.setPreferredSize(new Dimension(160, 21));
			name.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			namePanel.add(name);
			bottomLeftPanel.add(namePanel, BorderLayout.NORTH);
			
			facePreview = new FaceplatePreviewCanvas(theParent, theFaceplateImage);
			
			bottomLeftPanel.add(facePreview);
			
			
			JPanel browseFaceplatePanel = new JPanel(new FlowLayout());
			JButton browseFaceplateButton = new JButton("Browse Face Image...");
			browseFaceplateButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
//					JOptionPane.showMessageDialog(null, "Placeholder for browse functionality");
					
					FileDialog fd = new FileDialog(grandParent);
					
					fd.setMode(FileDialog.LOAD);
					
					fd.setModal(true);
					
					fd.setVisible(true);
					
					if(fd.getFile() == null || fd.getDirectory() == null)
						return;
					
					BufferedImage newImage = null;
					
					try {
						newImage = ImageIO.read(new File(fd.getDirectory() + fd.getFile()));
					} catch(FileNotFoundException fnfe) {
						JOptionPane.showMessageDialog(null, "Couldn't find the file: " + fd.getFile(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					} catch(IOException ioe) {
						JOptionPane.showMessageDialog(null, "The following file wasn't a readable image: " + fd.getFile(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
					
					
					facePreview.image = newImage;
					facePreview.facePreviewPathname = fd.getDirectory() + fd.getFile();
					
				}
			});
			browseFaceplatePanel.add(browseFaceplateButton);
			bottomLeftPanel.add(browseFaceplatePanel, BorderLayout.SOUTH);
			
			bottomPanel.add(bottomLeftPanel);
			
			JPanel bottomRightPanel = new JPanel(new GridLayout(4, 1));
			
			JPanel speedPanel = new JPanel(new FlowLayout());
			JLabel speedLabel = new JLabel("Speed:");
			speed = new JTextArea(Integer.toString(theSpeed));
			speed.setPreferredSize(new Dimension(60, 21));
			speed.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			speedPanel.add(speedLabel);
			speedPanel.add(speed);
			
			bottomRightPanel.add(speedPanel);
			
			
			JPanel healthPanel = new JPanel(new FlowLayout());
			JLabel healthLabel = new JLabel("health:");
			health = new JTextArea(Integer.toString(theHealth));
			health.setPreferredSize(new Dimension(60, 21));
			health.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			healthPanel.add(healthLabel);
			healthPanel.add(health);
			
			bottomRightPanel.add(healthPanel);
			
			
			
			JPanel textColorPanel = new JPanel(new FlowLayout());
			JButton changeTextColorButton = new JButton("Text Color...");
			changeTextColorButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					
					JDialog modal = new JDialog();
					BackgroundColorPopUpPanel textPopup = new BackgroundColorPopUpPanel(textColorCanvas == null ? Color.black : textColorCanvas.getSingleColor(), modal, false);
					modal.setContentPane(textPopup);
					
					modal.setModal(true);
					
					modal.setVisible(true);
					
					
					Color newTextColor = textPopup.getResultColor();
					
					if(newTextColor == null)
						return;
					
					textColorCanvas.setSingleColor(newTextColor);
					textColorCanvas.repaint();
					
				}
			});
			textColorPanel.add(changeTextColorButton);
			textColorCanvas = new MiniColorCanvas(null, null);
			textColorCanvas.setSingleColor(theTextColor);
			textColorCanvas.setPreferredSize(new Dimension(63, 40));
			textColorCanvas.setMinimumSize(new Dimension(63, 40));
			textColorCanvas.setMaximumSize(new Dimension(63, 40));
			textColorPanel.add(textColorCanvas);
			bottomRightPanel.add(textColorPanel);
			
			
			
			
			
			JPanel bgColorPanel = new JPanel(new FlowLayout());
			JButton changeBgColorButton = new JButton("BG Color...");
			changeBgColorButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					
					JDialog modal = new JDialog();
					BackgroundColorPopUpPanel textPopup = new BackgroundColorPopUpPanel(backgroundColorCanvas == null ? Color.black : backgroundColorCanvas.getSingleColor(), modal, false);
					modal.setContentPane(textPopup);
					
					modal.setModal(true);
					
					modal.setVisible(true);
					
					
					Color newBgColor = textPopup.getResultColor();
					
					if(newBgColor == null)
						return;
					
					backgroundColorCanvas.setSingleColor(newBgColor);
					backgroundColorCanvas.repaint();
					
				}
			});
			bgColorPanel.add(changeBgColorButton);
			backgroundColorCanvas = new MiniColorCanvas(null, null);
			backgroundColorCanvas.setSingleColor(theBgColor);
			backgroundColorCanvas.setPreferredSize(new Dimension(63, 40));
			backgroundColorCanvas.setMinimumSize(new Dimension(63, 40));
			backgroundColorCanvas.setMaximumSize(new Dimension(63, 40));
			bgColorPanel.add(backgroundColorCanvas);
			bottomRightPanel.add(bgColorPanel);
			
			
			
			bottomPanel.add(bottomRightPanel);
			
			
			
			this.add(bottomPanel);
			
			
		}
		
	}
	
	public class PlayerCharacterPreviewCanvas extends JPanel implements Runnable {
		
		private JPanel canvasPanel;
		private BackdropListedImage[] backdropImages;
		private DefaultComboBoxModel backdropListModel;
		private JComboBox backdropList;
		
		private JDialog grandParent;
		private PlayerCharacterEditorPanel parent;
		
		private int hitBoxColorCounter = 0;
		
		
		
		public PlayerCharacterPreviewCanvas(JDialog theGrandParent, PlayerCharacterEditorPanel theParent) {
			
			grandParent = theGrandParent;
			parent = theParent;

			this.setBorder(BorderFactory.createTitledBorder("Character/Hitbot Preview"));
			
			backdropImages = new BackdropListedImage[23];
			
			ImageIcon tempIcon = null;
			ImageIcon tempPrevIcon = null;
			BackdropListedImage tempImage = null;
			

			//tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/no_preview_available.GIF"));
			
			
			currentImage = noPreviewImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[0] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[1] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[2] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_check.GIF"));
			tempImage = new BackdropListedImage("Black&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[3] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Black&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[4] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Black&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[5] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[6] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_mini_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[7] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_micro_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[8] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[9] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_mini_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[10] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_micro_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[11] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[12] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_mini_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[13] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_micro_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[14] = tempImage;
			
			
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/white.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_white.GIF"));
			tempImage = new BackdropListedImage("Solid White", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[15] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black.GIF"));
			tempImage = new BackdropListedImage("Solid Black", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[16] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red.GIF"));
			tempImage = new BackdropListedImage("Solid Red", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[17] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow.GIF"));
			tempImage = new BackdropListedImage("Solid Yellow", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[18] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green.GIF"));
			tempImage = new BackdropListedImage("Solid Lime", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[19] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/cyan.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_cyan.GIF"));
			tempImage = new BackdropListedImage("Solid Cyan", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[20] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/blue.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_blue.GIF"));
			tempImage = new BackdropListedImage("Solid Blue", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[21] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/magenta.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_magenta.GIF"));
			tempImage = new BackdropListedImage("Solid Magenta", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[22] = tempImage;	
			
			
			
			
			JPanel backdropListPanel = new JPanel(new FlowLayout());
			
			backdropListModel = new DefaultComboBoxModel();
			backdropList = new JComboBox(backdropListModel);
			backdropListPanel.add(backdropList);
			
			for(ListedImage li : backdropImages) {
				backdropListModel.addElement(li);
			}
			
			backdropList.addItemListener(new ItemListener() {

				public void itemStateChanged(ItemEvent arg0) {
					
//					System.out.println("now in itemStateChanged!");
					
//					int index = backdropList.getSelectedIndex();
//					if(index < 0)
//						index = 0;
//					
//					ListedImage li = (ListedImage) backdropListModel.getElementAt(index);
					
//					System.out.println("li's name is: " + li.getFileName());
					repaint();
				}
				
			});
			
			canvasPanel = new PlayerCharacterAnimationPreviewCanvas() ;
			
			this.setLayout(new BorderLayout());
			
			this.add(canvasPanel, BorderLayout.CENTER);
			
			JPanel bottomPane = new JPanel(new FlowLayout());
			
			bottomPane.add(new JLabel("Backdrop:"));
			bottomPane.add(backdropList, BorderLayout.SOUTH);
			this.add(bottomPane, BorderLayout.SOUTH);
			
			Thread t = new Thread(this);
			t.start();
			
		}
		
		
		public class PlayerCharacterAnimationPreviewCanvas extends JPanel {
			public void paintComponent(Graphics g) {
				
				super.paintComponents(g);
				
//				System.out.println("<><>DELME now in paintComponent for PlayerCharacterAnimationPreviewCanvas");
				
				Image im = ((ListedImage) backdropListModel.getElementAt(backdropList.getSelectedIndex())).getImage();
				
				int width = im.getWidth(this);
				int height = im.getHeight(this);
				
				g.drawImage(((ListedImage) backdropListModel.getElementAt(backdropList.getSelectedIndex())).getImage(), getCurrentWidth() / 2 - width/2, getCurrentHeight() / 2 - height / 2, null);
				
				
				if(currentImage != null ) {
					g.drawImage(currentImage, getCurrentWidth() / 2 - currentImage.getWidth() / 2, getCurrentHeight() / 2 - currentImage.getHeight() / 2, null);
				}
				
				Integer theHitboxWidth = getNumericValue(parent.statPanel.hitboxWidth);
				Integer theHitboxHeight = getNumericValue(parent.statPanel.hitboxHeight);
				Integer theYOffset = getNumericValue(parent.statPanel.hitboxYOffset);
				
				if(theHitboxWidth != null 
						&& theHitboxHeight != null
						&& theYOffset != null) {
					
					Color origCol = g.getColor();
					
					hitBoxColorCounter += 10;
					
					if(hitBoxColorCounter >= 510) {
						hitBoxColorCounter = 0;
					}
					
					g.setColor(getHitboxColor());
					
					g.fillRect(getCurrentWidth() / 2 - theHitboxWidth / 2, getCurrentHeight() / 2 - theHitboxHeight / 2 + theYOffset + 1, theHitboxWidth, theHitboxHeight);
					
					
					g.setColor(new Color(0, 200, 0));
					
					g.fillRect(0, getCurrentHeight() / 2 - theHitboxHeight / 2 + theHitboxHeight + theYOffset + 1, getCurrentWidth(), getCurrentHeight() / 2 );
					
					g.setColor(origCol);
					
				}
				
				
			}
		}
		
		private Color getHitboxColor() {
			
			if(hitBoxColorCounter >= 255) {
				return new Color(0, 510 - hitBoxColorCounter , 255, 100);
			} else {
				return new Color(0, hitBoxColorCounter , 255, 100);
			}
			
		}
		
		public int getCurrentWidth() {
			return canvasPanel.getSize().width;
		}
		
		public int getCurrentHeight() {
			return canvasPanel.getSize().height;
		}
		
		public boolean canRunAnyImagesFromArray(ListedCustomImage imArray[]) {
			
			if(imArray != null && imArray.length > 0) {
				
				boolean noNullImages = true;
				
				for(ListedCustomImage i : imArray) {
					if(i == null || i.getImage() == null) {
						noNullImages = false;
						break;
					}
				}
				
				
				if(noNullImages)
					return true;
			}
			
			return false;
			
		}
		
		public boolean canRunAnyImagesFromAnyArray() {
			
			if(parent.leftAnimPanel != null 
					&& parent.leftAnimPanel.standAnimPanel != null
					&& canRunAnyImagesFromArray(parent.leftAnimPanel.standAnimPanel.getImageArray())) {
				return true;
			}
			if(parent.leftAnimPanel != null 
					&& parent.leftAnimPanel.walkAnimPanel != null
					&& canRunAnyImagesFromArray(parent.leftAnimPanel.walkAnimPanel.getImageArray())) {
				return true;
			}
			if(parent.rightAnimPanel != null
					&& parent.rightAnimPanel.standAnimPanel != null
					&& canRunAnyImagesFromArray(parent.rightAnimPanel.standAnimPanel.getImageArray())) {
				return true;
			}
			if(parent.rightAnimPanel != null
					&& parent.rightAnimPanel.walkAnimPanel != null
					&& canRunAnyImagesFromArray(parent.rightAnimPanel.walkAnimPanel.getImageArray())) {
				return true;
			}
			
			
			return false;
		}
		
		public void run() {
			
			try {
				Thread.sleep(1000);
			} catch(Exception e) {
				
			}
			
			int currentAnimation = -1;
			int currentIndex = 0;
			int remainingImages = 0;
			BufferedImage imArray[] = null;
			
			
			while(true) {
				

				long time = System.currentTimeMillis() + 100;
				
				if(canRunAnyImagesFromAnyArray()) {
					
//					System.out.println("+++++++++++++++++++++++++++START");
//					
//					System.out.println("remainingImages: " + remainingImages + ",  currentIndex: " + currentIndex + ", current animation: " + currentAnimation + ", isFacingLeft: " + facingLeft);
					
					if(remainingImages <= 0 || imArray == null) {
						
						justSwitchedCharacterImage = true;
						
						remainingImages = 40;
						currentIndex = 0;
						
						
						currentAnimation++;
						
						if(currentAnimation >= 4)  {
							currentAnimation = 0;
						}
						
						boolean canBreakOut = false;
						int laps = 0;
						
						
						while(!canBreakOut) {
							switch(currentAnimation) {
							case 0:
								laps++;
								if(canRunAnyImagesFromArray(parent.leftAnimPanel.standAnimPanel.getImageArray())) {
									canBreakOut = true;
								} else {
									currentAnimation = 1;
								}
								break;
							case 1:
								if(canRunAnyImagesFromArray(parent.leftAnimPanel.walkAnimPanel.getImageArray())) {
									canBreakOut = true;
								} else {
									currentAnimation = 2;
								}
								break;
							case 2:
								if(canRunAnyImagesFromArray(parent.rightAnimPanel.standAnimPanel.getImageArray())) {
									canBreakOut = true;
								} else {
									currentAnimation = 3;
								}
								break;
							case 3:
								if(canRunAnyImagesFromArray(parent.rightAnimPanel.walkAnimPanel.getImageArray())) {
									canBreakOut = true;
								} else {
									currentAnimation = 0;
								}
								break;
							}
							
							
							if(laps > 3) {
								canBreakOut = true;
								currentAnimation = -1;
							}
							
						}
						
					}
						
					switch(currentAnimation) {
					case 0:
						imArray = parent.leftAnimPanel.standAnimPanel.getTransparentedImageArray();
						facingLeft = true;
						break;
					case 1:
						imArray = parent.leftAnimPanel.walkAnimPanel.getTransparentedImageArray();
						facingLeft = true;
						break;
					case 2:
						imArray = parent.rightAnimPanel.standAnimPanel.getTransparentedImageArray();
						facingLeft = false;
						break;
					case 3:
						imArray = parent.rightAnimPanel.walkAnimPanel.getTransparentedImageArray();
						facingLeft = false;
						break;
					default:
						imArray = new BufferedImage[]{noPreviewImage};
					}
					
					currentIndex++;
					
					if(currentIndex >= imArray.length) {
						currentIndex = 0;
					}
					
					try {
						currentImage = imArray[currentIndex];
					} catch(IndexOutOfBoundsException e) {
						System.out.println("EXCEPTION!!!");
						continue;
					}
					
//					System.out.println("");
					
					remainingImages--;
						
					
					
					
				} else {
					currentImage = noPreviewImage;
				}
				
				if(grandParent == null || !grandParent.isVisible()) {
//					System.out.println("<><>DELME stopping now");
					return;
				}
				
//				this.repaint();
				
				while(System.currentTimeMillis() < time) {
					Thread.yield();
				}
				
			}
			
			
		}
		
		
		
		
	}
	
	
	
	public class FaceplatePreviewCanvas extends JPanel implements Runnable {

		private BufferedImage canvas;
		
		private BufferedImage image;
		
		private BufferedImage heartImage;
		private BufferedImage brokenHeartImage;
		private BufferedImage plusImage;
		
		private PlayerCharacterEditorPanel grandParent;
		
		private BufferedImage noFaceplatePreviewImage;
		private String facePreviewPathname = null;
		
		
		public FaceplatePreviewCanvas(PlayerCharacterEditorPanel theGrandParent, String theFaceplateImage) {
			this.setBorder(BorderFactory.createTitledBorder("Faceplate Preivew"));
			
			grandParent = theGrandParent;
			
			try {
				
				heartImage = ImageIO.read(FaceplatePreviewCanvas.class.getResource("/images/fullHeart2.GIF"));
				heartImage = CustomImageDataII.makeImageTransparent(heartImage, Color.white);
				
				brokenHeartImage = ImageIO.read(FaceplatePreviewCanvas.class.getResource("/images/brokenHeart2.GIF"));
				brokenHeartImage = CustomImageDataII.makeImageTransparent(brokenHeartImage, Color.white);
				
				plusImage = ImageIO.read(FaceplatePreviewCanvas.class.getResource("/images/plus.GIF"));
				plusImage = CustomImageDataII.makeImageTransparent(plusImage, Color.white);
				
				noFaceplatePreviewImage = ImageIO.read(FaceplatePreviewCanvas.class.getResource("/images/no_image_red_white.GIF"));
				
				GraphicsConfiguration gc = CustomImageDataII.getGC();
				canvas = gc.createCompatibleImage(101, 111, Transparency.TRANSLUCENT);
				
				
				try {
					if(theFaceplateImage != null) {
						image = ImageIO.read(new File(theFaceplateImage));
						facePreviewPathname = theFaceplateImage;
					}
				} catch(Exception e) {
					JOptionPane.showMessageDialog(null, "<html>Unable to load the given file: " + theFaceplateImage + ", exception details:<br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>"), "Error", JOptionPane.ERROR_MESSAGE);
				}
				
			} catch(Exception e) {
				JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e));
			}
			
			
			
			Thread t = new Thread(this);
			t.start();
			
		}
		
		
		public void paintComponent(Graphics g) {
			
			Color origCol = g.getColor();
			
			g.setColor(grandParent.getBackground());
			
			g.fillRect(0, 0, this.getWidth(), this.getHeight());
			
			
			g.setColor(origCol);
			
			
			super.paintComponents(g);
			
//			System.out.println("<><>DELME now in paintComponent for FaceplatePreviewCanvas");
			
			if(canvas != null) {
				g.drawImage(canvas, 10, 15, null);
				return;
			}
			
			
			/*if(grandParent.statPanel.backgroundColorCanvas.getSingleColor() != null
					&& grandParent.statPanel.textColorCanvas.getSingleColor() != null) {
				
				Color origColor = g.getColor();
				
				
				g.setColor(grandParent.statPanel.backgroundColorCanvas.getSingleColor());
				
				g.fillRect(10, 15, 100, 110);
				
				g.setColor(grandParent.statPanel.textColorCanvas.getSingleColor());
				
				g.drawRect(10, 15, 100, 110);
				
				if(image == null)
					image = noFaceplatePreviewImage;
				g.drawImage(image, 15, 21, null);
				
				int charHealth = -1;
				try {
					charHealth = Integer.parseInt(grandParent.statPanel.health.getText().trim());
				} catch(NumberFormatException e) {
					//do nothing
				} catch(NullPointerException e) {
					//do nothing
				}
				
				if(charHealth > 0) {
					
					int numberOfWholeHearts = (int) ((System.currentTimeMillis() / 1000) % (charHealth + 1));
					
					BufferedImage tempImage;
					
					for(int i = 0; i < 7; i++) {
						
						if(i >= charHealth) {
							i = 8;
							continue;
						}
						
						if(i <= numberOfWholeHearts) {
							tempImage = heartImage;
						} else {
							tempImage = brokenHeartImage;
						}
						
						g.drawImage(tempImage, i % 2 != 1 ? 76 : 94, (i / 2) * 14 + 16, null);
						
					}
					
				}
				
				
				Font origFont = g.getFont();
				
				Font newFont = new Font(origFont.getName(), Font.BOLD, 12);
				
				g.setFont(newFont);
				
				String charName = "Name";
				
				try {
					charName = grandParent.statPanel.name.getText().trim();
				} catch(NullPointerException e) {
					//ignore;
				}
				
				g.drawString(charName, 15, 90);
				
				
				g.setFont(origFont);
				g.setColor(origColor);
				
			}*/
			
			
		}
		
		
		@Override
		public void run() {
			
			try {
				Thread.sleep(1000L);
			} catch(Exception e) {
				//ignore
			}
			
			while(grandParent.parent.isVisible() && canvas != null) {
				
				Graphics g = canvas.getGraphics();
				
				if(grandParent.statPanel.backgroundColorCanvas.getSingleColor() != null
						&& grandParent.statPanel.textColorCanvas.getSingleColor() != null) {
					
					Color origColor = g.getColor();
					
					
					g.setColor(grandParent.statPanel.backgroundColorCanvas.getSingleColor());
					
					g.fillRect(0, 0, 100, 110);
					
					g.setColor(grandParent.statPanel.textColorCanvas.getSingleColor());
					
					g.drawRect(0, 0, 100, 110);
					
					if(image == null)
						image = noFaceplatePreviewImage;
					g.drawImage(image, 5, 6, 50, 50, null);
					
					int charHealth = -1;
					try {
						charHealth = Integer.parseInt(grandParent.statPanel.health.getText().trim());
					} catch(NumberFormatException e) {
						//do nothing
					} catch(NullPointerException e) {
						//do nothing
					}
					
					if(charHealth > 0) {
						
						int numberOfWholeHearts = (int) ((System.currentTimeMillis() / 1000) % (Math.min(charHealth, 9) + 1));
						
//						System.out.println("<><>DELME numberOfWholeHearts: " + numberOfWholeHearts);
						
						BufferedImage tempImage;
						
						for(int i = 0; i < 7; i++) {
							
							if(i >= charHealth) {
								i = 8;
								continue;
							}
							
							if(i <= numberOfWholeHearts) {
								tempImage = heartImage;
							} else {
								tempImage = brokenHeartImage;
							}
							
							g.drawImage(tempImage, i % 2 != 1 ? 66 : 84, (i / 2) * 14 + 1, null);
							
						}
						
						if(charHealth == 8) {
							
							if(numberOfWholeHearts < 7) {
								tempImage = brokenHeartImage;
							} else {
								tempImage = heartImage;
							}
							
							g.drawImage(tempImage,  84, 43, null);
						}
						
						if(charHealth > 8) {
							
							if(numberOfWholeHearts > 7) {
								tempImage = plusImage;
							} else if(numberOfWholeHearts == 7) {
								tempImage = heartImage;
							} else {
								tempImage = brokenHeartImage;
							}
							
							g.drawImage(tempImage,  84, 43, null);
						}
						
					}
					
					
					Font origFont = g.getFont();
					
					Font newFont = new Font(origFont.getName(), Font.BOLD, 12);
					
					g.setFont(newFont);
					
					String charName = "Name";
					
					try {
						charName = grandParent.statPanel.name.getText().trim();
					} catch(NullPointerException e) {
						//ignore;
					}
					
					g.drawString(charName, 5, 75);
					
					
					g.setFont(origFont);
					g.setColor(origColor);
					
				}
				
				g.dispose();
				
				this.repaint();
				
				try {
					Thread.sleep(100L);
				} catch(Exception e) {
					return;
				}
				
			} 
			
		}
		
		
		
		
	}
	
	
	
	public class BulletStatPanel extends JPanel implements Runnable {
		
		private DefaultComboBoxModel backdropListModel;
		private JComboBox backdropList;
		
		private BackdropListedImage[] backdropImages;
		
		
		private JTextArea attack;
		private JTextArea bulletSpawnXOffset;
		private JTextArea bulletSpawnYOffset;
		private JCheckBox spreadShots;
		private JCheckBox medic;
		
		private PlayerCharacterBulletPreviewCanvas previewCanvas;
		
		
		public BulletStatPanel(JDialog theGreatGrandParent, PlayerCharacterEditorPanel theGrandParent, int theBulletSpawnXOffset, int theBulletSpawnYOffset, boolean theMedic, boolean theSpread, int theAttack) {
			
			/*backdropImages = new BackdropListedImage[23];
			
			ImageIcon tempIcon = null;
			ImageIcon tempPrevIcon = null;
			BackdropListedImage tempImage = null;
			

			
			currentImage = noPreviewImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[0] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[1] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[2] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_check.GIF"));
			tempImage = new BackdropListedImage("Black&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[3] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Black&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[4] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Black&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[5] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[6] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_mini_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[7] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_micro_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[8] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[9] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_mini_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[10] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_micro_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[11] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[12] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_mini_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[13] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_micro_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[14] = tempImage;
			
			
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/white.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_white.GIF"));
			tempImage = new BackdropListedImage("Solid White", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[15] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black.GIF"));
			tempImage = new BackdropListedImage("Solid Black", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[16] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red.GIF"));
			tempImage = new BackdropListedImage("Solid Red", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[17] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow.GIF"));
			tempImage = new BackdropListedImage("Solid Yellow", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[18] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green.GIF"));
			tempImage = new BackdropListedImage("Solid Lime", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[19] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/cyan.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_cyan.GIF"));
			tempImage = new BackdropListedImage("Solid Cyan", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[20] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/blue.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_blue.GIF"));
			tempImage = new BackdropListedImage("Solid Blue", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[21] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/magenta.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_magenta.GIF"));
			tempImage = new BackdropListedImage("Solid Magenta", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[22] = tempImage;	
			
			
			
			
			JPanel backdropListPanel = new JPanel(new FlowLayout());
			
			backdropListModel = new DefaultComboBoxModel();
			backdropList = new JComboBox(backdropListModel);
			backdropListPanel.add(backdropList);
			
			for(ListedImage li : backdropImages) {
				backdropListModel.addElement(li);
			}
			
			backdropList.addItemListener(new ItemListener() {

				public void itemStateChanged(ItemEvent arg0) {
					
//					System.out.println("now in itemStateChanged!");
					
//					int index = backdropList.getSelectedIndex();
//					if(index < 0)
//						index = 0;
//					
//					ListedImage li = (ListedImage) backdropListModel.getElementAt(index);
					
//					System.out.println("li's name is: " + li.getFileName());
					repaint();
				}
				
			});*/
			
			
			
			this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
			
			JPanel topPanel = new JPanel(new GridLayout(1, 2));
			
			previewCanvas = new PlayerCharacterBulletPreviewCanvas(theGreatGrandParent, theGrandParent, this);
			
			topPanel.add(previewCanvas);
			
			
			JPanel offsetPanel = new JPanel(new GridLayout(3, 1));
			
			offsetPanel.add(new JPanel());
			
			JPanel xOffsetPanel = new JPanel(new FlowLayout());
			xOffsetPanel.add(new JLabel("Bullet spawn xOffset:"));
			bulletSpawnXOffset = new JTextArea(Integer.toString(theBulletSpawnXOffset));
			bulletSpawnXOffset.setPreferredSize(new Dimension(80, 21));
			bulletSpawnXOffset.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			xOffsetPanel.add(bulletSpawnXOffset);
			offsetPanel.add(xOffsetPanel);
			
			JPanel yOffsetPanel = new JPanel(new FlowLayout());
			yOffsetPanel.add(new JLabel("Bullet spawn yOffset:"));
			bulletSpawnYOffset = new JTextArea(Integer.toString(theBulletSpawnYOffset));
			bulletSpawnYOffset.setPreferredSize(new Dimension(80, 21));
			bulletSpawnYOffset.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			yOffsetPanel.add(bulletSpawnYOffset);
			offsetPanel.add(yOffsetPanel);
			
			topPanel.add(offsetPanel);
			
			this.add(topPanel);
			
			JPanel bottomPanel = new JPanel(new GridLayout(3, 1));
			bottomPanel.add(new JPanel());
			
			JPanel checkBoxesPanel = new JPanel(new GridLayout(1, 2));
			
			medic = new JCheckBox("Bullets should spawn hearts?");
			JPanel medicPanel = new JPanel(new FlowLayout());
			medicPanel.add(medic);
			medic.setSelected(theMedic);
			checkBoxesPanel.add(medicPanel);
			
			spreadShots = new JCheckBox("Spread shots?");
			JPanel spreadShotsPanel = new JPanel(new FlowLayout());
			spreadShotsPanel.add(spreadShots);
			spreadShots.setSelected(theSpread);
			checkBoxesPanel.add(spreadShotsPanel);
			
			bottomPanel.add(checkBoxesPanel);
			
			
			JPanel attackPanel = new JPanel(new FlowLayout());
			JLabel attackLabel = new JLabel("attack:");
			attack = new JTextArea(Integer.toString(theAttack));
			attack.setPreferredSize(new Dimension(60, 21));
			attack.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			attackPanel.add(attackLabel);
			attackPanel.add(attack);
			
			bottomPanel.add(attackPanel);
			
			this.add(bottomPanel);
			
			
		}
		
		
		public void run() {
			
		}
		
	}
	
	
	
	
	public static void main(String [] args) {
		
		JDialog frame = new JDialog();
		
		PlayerCharacterEditorPanel panel = new PlayerCharacterEditorPanel(frame);
		
		frame.setContentPane(panel);
		
		frame.setPreferredSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setMaximumSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
		frame.setVisible(true);
		
		
		
	}
	
	public static Integer getNumericValue(JTextArea textArea) {
		
		if(textArea == null || textArea.getText() == null || textArea.getText().trim().length() == 0)
			return null;
		
		try {
			return Integer.parseInt(textArea.getText().trim());
		} catch(NumberFormatException e) {
			return null;
		}
		
		
	}
	
	
	public class PlayerCharacterBulletPreviewCanvas extends JPanel 
	{
		
		private JPanel canvas;
		private BackdropListedImage[] backdropImages;
		private DefaultComboBoxModel backdropListModel;
		private JComboBox backdropList;
		
		private JDialog greatGrandParent;
		private PlayerCharacterEditorPanel grandParent;
		private BulletStatPanel parent;
		
		
		private int spawnPointColorCounter = 0;
		private int counterForBulletGraphic = 0;
		
		private boolean lastFacingLeft = false;
		
		private int countDownToFiring = -1;
		
		
		private ArrayList<SimulatedBullet> simulatedBullets;
		
		public PlayerCharacterBulletPreviewCanvas(JDialog theGreatGrandParent, PlayerCharacterEditorPanel theGrandParent, BulletStatPanel theParent) {
			
			greatGrandParent = theGreatGrandParent;
			grandParent = theGrandParent;
			parent = theParent;

			simulatedBullets = new ArrayList<SimulatedBullet>();
			
			this.setBorder(BorderFactory.createTitledBorder("Preview"));
			
			backdropImages = new BackdropListedImage[23];
			
			ImageIcon tempIcon = null;
			ImageIcon tempPrevIcon = null;
			BackdropListedImage tempImage = null;
			
			int currentBulletImage = 0;

			//tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/no_preview_available.GIF"));
			
			
//			currentImage = noPreviewImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[0] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[1] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/silver_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_silver_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Silver&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[2] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_check.GIF"));
			tempImage = new BackdropListedImage("Black&White L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[3] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_mini_check.GIF"));
			tempImage = new BackdropListedImage("Black&White M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[4] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black_white_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black_white_micro_check.GIF"));
			tempImage = new BackdropListedImage("Black&White S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[5] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[6] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_mini_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[7] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red_cyan_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red_cyan_micro_check.GIF"));
			tempImage = new BackdropListedImage("Red&Cyan S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[8] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[9] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_mini_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[10] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow_blue_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow_blue_micro_check.GIF"));
			tempImage = new BackdropListedImage("Yellow&Blue S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[11] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta L", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[12] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_mini_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_mini_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta M", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[13] = tempImage;
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green_magenta_micro_check.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green_magenta_micro_check.GIF"));
			tempImage = new BackdropListedImage("Green&Magenta S", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[14] = tempImage;
			
			
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/white.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_white.GIF"));
			tempImage = new BackdropListedImage("Solid White", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[15] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/black.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_black.GIF"));
			tempImage = new BackdropListedImage("Solid Black", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[16] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/red.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_red.GIF"));
			tempImage = new BackdropListedImage("Solid Red", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[17] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/yellow.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_yellow.GIF"));
			tempImage = new BackdropListedImage("Solid Yellow", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[18] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/green.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_green.GIF"));
			tempImage = new BackdropListedImage("Solid Lime", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[19] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/cyan.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_cyan.GIF"));
			tempImage = new BackdropListedImage("Solid Cyan", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[20] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/blue.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_blue.GIF"));
			tempImage = new BackdropListedImage("Solid Blue", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[21] = tempImage;
			
			tempIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/magenta.GIF"));
			tempPrevIcon = new ImageIcon(CustomAnimationPanel.class.getResource("/images/prev_magenta.GIF"));
			tempImage = new BackdropListedImage("Solid Magenta", tempIcon.getImage(), tempPrevIcon.getImage());
			backdropImages[22] = tempImage;	
			
			
			
			
			JPanel backdropListPanel = new JPanel(new FlowLayout());
			
			backdropListModel = new DefaultComboBoxModel();
			backdropList = new JComboBox(backdropListModel);
			backdropListPanel.add(backdropList);
			
			for(ListedImage li : backdropImages) {
				backdropListModel.addElement(li);
			}
			
			backdropList.addItemListener(new ItemListener() {

				public void itemStateChanged(ItemEvent arg0) {
					
//					System.out.println("now in itemStateChanged!");
					
//					int index = backdropList.getSelectedIndex();
//					if(index < 0)
//						index = 0;
//					
//					ListedImage li = (ListedImage) backdropListModel.getElementAt(index);
					
//					System.out.println("li's name is: " + li.getFileName());
					repaint();
				}
				
			});
			
			canvas = new JPanel() { 
				public void paintComponent(Graphics g) {
					
					super.paintComponents(g);
					
//					System.out.println("<><>DELME now in paintComponent for PlayerCharacterBulletPreviewCanvas");
					
					if(justSwitchedCharacterImage) {
						if(countDownToFiring < 0) {
							countDownToFiring = 4;
						}
						justSwitchedCharacterImage = false;
					}
					
					
					Image im = ((ListedImage) backdropListModel.getElementAt(backdropList.getSelectedIndex())).getImage();
					
					int width = im.getWidth(this);
					int height = im.getHeight(this);
					
					g.drawImage(((ListedImage) backdropListModel.getElementAt(backdropList.getSelectedIndex())).getImage(), getCurrentWidth() / 2 - width/2, getCurrentHeight() / 2 - height / 2, null);
					
					
					
					
					Integer theBulletSpawnXOffset = getNumericValue(parent.bulletSpawnXOffset);
					Integer theBulletSpawnYOffset = getNumericValue(parent.bulletSpawnYOffset);
					
					
					Image currentBulletImage = null;
					ListedCustomImage bulletImageArray[] = grandParent.bulletPanel.getImageArray();
					if(canRunAnyImagesFromArray(bulletImageArray)) {
						
						if(counterForBulletGraphic >= bulletImageArray.length) {
							counterForBulletGraphic = 0;
						}
						
						currentBulletImage = bulletImageArray[counterForBulletGraphic++].getImage();
						
					} 
					
					
					for(int i = 0; i < simulatedBullets.size(); i++) {
						simulatedBullets.get(i).draw(g);
						if(simulatedBullets.get(i).canErase()) {
							simulatedBullets.remove(i);
							i--;
						}
					}
					
					
					
					
					int placeToDrawImageX, placeToDrawImageY, imageCenterX = 0, imageCenterY = 0;
					
					if(currentImage != null ) {
						if(theBulletSpawnXOffset == null || theBulletSpawnYOffset == null) {
							g.drawImage(currentImage, getCurrentWidth() / 2 - currentImage.getWidth() / 2, getCurrentHeight() / 2 - currentImage.getHeight() / 2, null);
						} else {
							
							if(!facingLeft) {
								placeToDrawImageX = 0;
								imageCenterX = currentImage.getWidth() / 2;
							} else {
								placeToDrawImageX = getCurrentWidth() - currentImage.getWidth();
								imageCenterX = getCurrentWidth() - currentImage.getWidth() / 2;
							}
							
							placeToDrawImageY = getCurrentHeight() / 2 - currentImage.getHeight() / 2;
							imageCenterY = getCurrentHeight() / 2;
							
							g.drawImage(currentImage, placeToDrawImageX, placeToDrawImageY, null);
							
						}
					}
					
					if(theBulletSpawnXOffset != null 
							&& theBulletSpawnYOffset != null) {
						
						Color origCol = g.getColor();
						
						g.setColor(PlayingWithCosine.scalarToColor(Math.random()));
						
						
						int centerX, centerY;
						
						if(facingLeft) {
							centerX = imageCenterX - theBulletSpawnXOffset;
							centerY = imageCenterY + theBulletSpawnYOffset;
							
//							if(!lastFacingLeft) {
//								countDownToFiring = 4;
//							}
							
						} else {
							centerX = imageCenterX + theBulletSpawnXOffset;
							centerY = imageCenterY + theBulletSpawnYOffset;
							
//							if(lastFacingLeft) {
//								countDownToFiring = 4;
//							}
							
						}
						
						
						lastFacingLeft = facingLeft;
						
						if(countDownToFiring > 0) {
							countDownToFiring--;
						} else if(countDownToFiring == 0) {
							
							SimulatedBullet tempBullet = new SimulatedBullet(grandParent.bulletPanel.getTransparentedImageArray(), facingLeft ? 'l' : 'r', centerX, centerY);
							simulatedBullets.add(tempBullet);
							
							if(parent.spreadShots != null && parent.spreadShots.isSelected()) {
								//fire two more
								tempBullet = new SimulatedBullet(grandParent.bulletPanel.getTransparentedImageArray(), facingLeft ? 'w' : 'e', centerX, centerY);
								simulatedBullets.add(tempBullet);
								tempBullet = new SimulatedBullet(grandParent.bulletPanel.getTransparentedImageArray(), facingLeft ? 'p' : 's', centerX, centerY);
								simulatedBullets.add(tempBullet);
							}
							
							countDownToFiring = -1;
						}
						
						
						int leftX = centerX - 6;
						int rightX = centerX + 6;
						int topY = centerY - 6;
						int bottomY = centerY + 6;
						
						g.drawLine(leftX, topY, rightX, bottomY);
						g.drawLine(leftX, bottomY, rightX, topY);
						
						g.drawOval(leftX, topY, 13, 13);
						
//						g.fillRect(getCurrentWidth() / 2 - theBulletSpawnXOffset / 2, getCurrentHeight() / 2 - theBulletSpawnYOffset / 2 + theYOffset, theBulletSpawnXOffset, theBulletSpawnYOffset);
						
						
//						g.setColor(new Color(0, 200, 0));
//						
//						g.fillRect(0, getCurrentHeight() / 2 - theBulletSpawnYOffset / 2 + theBulletSpawnYOffset + theYOffset, getCurrentWidth(), getCurrentHeight() / 2 );
						
						g.setColor(origCol);
						
					}
					
					
				}
			};
			
			this.setLayout(new BorderLayout());
			
			this.add(canvas, BorderLayout.CENTER);
			
			JPanel bottomPane = new JPanel(new FlowLayout());
			
			bottomPane.add(new JLabel("Backdrop:"));
			bottomPane.add(backdropList, BorderLayout.SOUTH);
			this.add(bottomPane, BorderLayout.SOUTH);
			
//			Thread t = new Thread(this);
//			t.start();
			
		}
		
		public class SimulatedBullet {
			
			
			
			private BufferedImage [] img;
			private char direction;
			
			private int xPos;
			private int yPos;
			
			private int index;
			
			public SimulatedBullet(BufferedImage [] theImage, char theDirection, int initialX, int initialY) {
				
				img = theImage;
				direction = theDirection;
				
				xPos = initialX;
				yPos = initialY;
				
				index = 0;
				
			}
			
			public void draw(Graphics g) {
				
				if(img == null || img.length == 0) {
					Color col = g.getColor();
					
					g.setColor(PlayingWithCosine.scalarToColor(Math.random()));
					
					g.fillOval(xPos-2, yPos-2, 5, 5);
					g.drawOval(xPos-5, yPos-5, 11, 11);
					
					g.setColor(col);
				} else {
					
					index++;
					
					if(index >= img.length)
						index = 0;
					
					g.drawImage(img[index], xPos - img[index].getWidth()/2, yPos - img[index].getHeight() / 2, parent);
				}
				
				switch(direction) {
				case 'l':
					xPos -= BulletSprite.BULLET_SPEED;
					break;
				case 'w':
					xPos -= BulletSprite.BULLET_X_SPREAD;
					yPos += BulletSprite.BULLET_Y_SPREAD;
					break;
				case 'p':
					xPos -= BulletSprite.BULLET_X_SPREAD;
					yPos -= BulletSprite.BULLET_Y_SPREAD;
					break;
				case 'r':
					xPos += BulletSprite.BULLET_SPEED;
					break;
				case 'e':
					xPos += BulletSprite.BULLET_X_SPREAD;
					yPos += BulletSprite.BULLET_Y_SPREAD;
					break;
				case 's':
					xPos += BulletSprite.BULLET_X_SPREAD;
					yPos -= BulletSprite.BULLET_Y_SPREAD;
					break;
				}
			}
			
			
			public boolean canErase() {
				return xPos < 0 || xPos > getCurrentWidth();
			}
			
		}
		
		private Color getSpawnPointColor() {
			
			if(spawnPointColorCounter >= 255) {
				return new Color(255, 510 - spawnPointColorCounter , 0, 100);
			} else {
				return new Color(255, spawnPointColorCounter , 0, 100);
			}
			
		}
		
		public int getCurrentWidth() {
			return canvas.getSize().width;
		}
		
		public int getCurrentHeight() {
			return canvas.getSize().height;
		}
		
		public boolean canRunAnyImagesFromArray(ListedCustomImage imArray[]) {
			
			if(imArray != null && imArray.length > 0) {
				
				boolean noNullImages = true;
				
				for(ListedCustomImage i : imArray) {
					if(i == null || i.getImage() == null) {
						noNullImages = false;
						break;
					}
				}
				
				
				if(noNullImages)
					return true;
			}
			
			return false;
			
		}
		
		public boolean canRunAnyImagesFromAnyArray() {
			
			if(grandParent.leftAnimPanel != null 
					&& grandParent.leftAnimPanel.standAnimPanel != null
					&& canRunAnyImagesFromArray(grandParent.leftAnimPanel.standAnimPanel.getImageArray())) {
				return true;
			}
			if(grandParent.leftAnimPanel != null 
					&& grandParent.leftAnimPanel.walkAnimPanel != null
					&& canRunAnyImagesFromArray(grandParent.leftAnimPanel.walkAnimPanel.getImageArray())) {
				return true;
			}
			if(grandParent.rightAnimPanel != null
					&& grandParent.rightAnimPanel.standAnimPanel != null
					&& canRunAnyImagesFromArray(grandParent.rightAnimPanel.standAnimPanel.getImageArray())) {
				return true;
			}
			if(grandParent.rightAnimPanel != null
					&& grandParent.rightAnimPanel.walkAnimPanel != null
					&& canRunAnyImagesFromArray(grandParent.rightAnimPanel.walkAnimPanel.getImageArray())) {
				return true;
			}
			
			
			return false;
		}
		
		/*public void run() {
			
			try {
				Thread.sleep(1000);
			} catch(Exception e) {
				
			}
			
			int currentAnimation = -1;
			int currentIndex = 0;
			int remainingImages = 0;
			BufferedImage imArray[] = null;
			
			
			while(true) {
				

				long time = System.currentTimeMillis() + 100;
				
//				if(canRunAnyImagesFromAnyArray()) {
//					
//					if(remainingImages <= 0 || imArray == null) {
//						remainingImages = 40;
//						currentIndex = 0;
//						
//						
//						currentAnimation++;
//						
//						if(currentAnimation >= 4)  {
//							currentAnimation = 0;
//						}
//						
//						boolean canBreakOut = false;
//						
//						while(!canBreakOut) {
//							switch(currentAnimation) {
//							case 0:
//								if(canRunAnyImagesFromArray(grandParent.leftAnimPanel.standAnimPanel.getImageArray())) {
//									canBreakOut = true;
//								} else {
//									currentAnimation = 1;
//								}
//								break;
//							case 1:
//								if(canRunAnyImagesFromArray(grandParent.leftAnimPanel.walkAnimPanel.getImageArray())) {
//									canBreakOut = true;
//								} else {
//									currentAnimation = 2;
//								}
//								break;
//							case 2:
//								if(canRunAnyImagesFromArray(grandParent.rightAnimPanel.standAnimPanel.getImageArray())) {
//									canBreakOut = true;
//								} else {
//									currentAnimation = 3;
//								}
//								break;
//							case 3:
//								if(canRunAnyImagesFromArray(grandParent.rightAnimPanel.walkAnimPanel.getImageArray())) {
//									canBreakOut = true;
//								} else {
//									currentAnimation = 0;
//								}
//								break;
//							}
//						}
//						
//					}
//						
//					switch(currentAnimation) {
//					case 0:
//						imArray = grandParent.leftAnimPanel.standAnimPanel.getTransparentedImageArray();
//						break;
//					case 1:
//						imArray = grandParent.leftAnimPanel.walkAnimPanel.getTransparentedImageArray();
//						break;
//					case 2:
//						imArray = grandParent.rightAnimPanel.standAnimPanel.getTransparentedImageArray();
//						break;
//					case 3:
//						imArray = grandParent.rightAnimPanel.walkAnimPanel.getTransparentedImageArray();
//						break;
//					}
//					
//					currentIndex++;
//					
//					if(currentIndex >= imArray.length) {
//						currentIndex = 0;
//					}
//					
//					try {
//						currentImage = imArray[currentIndex];
//					} catch(IndexOutOfBoundsException e) {
//						continue;
//					}
//					
//					remainingImages--;
//						
//					
//					System.out.println("after, and remainingImages: " + remainingImages + ",  currentIndex: " + currentIndex + ", current animation: " + currentAnimation + ", isFacingLeft: " + facingLeft);
//					
//					System.out.println("-------------------------------  END");
//					
//				} else {
//					currentImage = noPreviewImage;
//				}
				
				if(greatGrandParent == null || !greatGrandParent.isVisible()) {
					System.out.println("<><>DELME stopping now");
					return;
				}
				
				this.repaint();
				
				System.out.println("<><>DELME drawing2");
				
				while(System.currentTimeMillis() < time) {
					Thread.yield();
				}
				
			}
			
			
		}*/
		
		
		
		
	}
	
	
	
	public Color getFaceplateBackgroundColor() {
		return this.statPanel.backgroundColorCanvas.getSingleColor();
	}
	
	public Color getFaceplateTextColor() {
		return this.statPanel.textColorCanvas.getSingleColor();
	}

	@Override
	public void run() {
		try {
			Thread.sleep(1000L);
		} catch(Exception e) {
			//ignore
		}
		
		while(parent.isVisible()) {
			
			this.repaint();
			
			try {
				Thread.sleep(100L);
			} catch(Exception e) {
				return;
			}
			
		}
	}
	

	public static boolean isCompleteFieldSummary(String [] contentArray) {
		
		
		Integer theHitboxWidth = null;
		Integer theHitBoxHeight = null;
		Integer theYOffset = null;
		String theCharName = null;
		Integer theSpeed = null;
		Integer theHealth = null;
		Color theFaceplateTextColor = null;
		Color theFaceplateBgColor = null;
		String theFaceplateImage = null;
		
		String theLeftStandAnim[] = null;
		
		String theLeftWalkAnim[] = null;
		
		String theLeftAirAnim[] = null;
		
		String theRightStandAnim[] = null;
		
		String theRightWalkAnim[] = null;
		
		String theRightAirAnim[] = null;
		
		String theBulletAnim[] = null;
		
		Integer theAttack = null;
		Boolean theSpread = null;
		Boolean theMedic = null;
		
		
		Integer theBulletSpawnXOffset = null;
		Integer theBulletSpawnYOffset = null;
		
		//dig it out of the array here
		
		if(contentArray != null) {
			for(int i = 0; i < contentArray.length; i++) {
				
				String s = contentArray[i];
				
				if(s.contains("HitBoxWidth:")) {
					try {
						theHitboxWidth = Integer.parseInt(s.substring(12).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("HitBoxHeight:")) {
					try {
						theHitBoxHeight = Integer.parseInt(s.substring(13).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("HitBoxYOffset:")) {
					try {
						theYOffset = Integer.parseInt(s.substring(14).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("CharName:")) {
					theCharName = s.substring(9).trim();
				} else if(s.contains("Speed:")) {
					try {
						theSpeed = Integer.parseInt(s.substring(6).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("Health:")) {
					try {
						theHealth = Integer.parseInt(s.substring(7).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("FaceplateTextColor:")) {
					theFaceplateTextColor = CustomAnimationPanel.convertStringToColor(s.substring(19));
				} else if(s.contains("FaceplateBgColor:")) {
					theFaceplateBgColor = CustomAnimationPanel.convertStringToColor(s.substring(17));
				} else if(s.contains("FaceplateImage:")) {
					theFaceplateImage = s.substring(15);
				} else if(s.contains("LeftStandAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(14).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theLeftStandAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether LeftStandAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("LeftWalkAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(13).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theLeftWalkAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether LeftWalkAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("LeftAirAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(12).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theLeftAirAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether LeftAirAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightStandAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(15).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theRightStandAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether RightStandAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightWalkAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(14).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theRightWalkAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether RightWalkAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("RightAirAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(13).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theRightAirAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether RightAirAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("BulletAnim:")) {
					try {
						int countOfItems = Integer.parseInt(s.substring(11).trim());
						
						ArrayList<String> tempList = new ArrayList<String>();
						
						for(int j = 0; i < contentArray.length && j < countOfItems; i += j++ - j + 1) {
							tempList.add(contentArray[i]);
						}
						
						theBulletAnim = tempList.toArray(new String[0]);
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(null, "<html> Error occurred while trying to check whether BulletAnim was a usable animation: <br><br>" + PonyPanel.formatStackTrace(e).replace("\n", "<br>") + "</html>", "Error while creating PlayerCharacterEditorPanel", JOptionPane.ERROR_MESSAGE);
					}
				} else if(s.contains("Attack:")) {
					try {
						theAttack = Integer.parseInt(s.substring(7).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("NoSpread")) {
					theSpread = false;
				} else if(s.contains("Spread")) {
					theSpread = true;
				} else if(s.contains("NoMedic")) {
					theMedic = false;
				} else if(s.contains("Medic")) {
					theMedic = true;
				} else if(s.contains("BulletSpawnXOffset:")) {
					try {
						theBulletSpawnXOffset = Integer.parseInt(s.substring(19).trim());
					} catch(NumberFormatException e) {}
				} else if(s.contains("BulletSpawnYOffset:")) {
					try {
						theBulletSpawnYOffset = Integer.parseInt(s.substring(19).trim());
					} catch(NumberFormatException e) {}
				}
				
				
			}
		}
		
		
		
		if( theHitboxWidth == null) return false;
		if( theHitBoxHeight == null) return false;
		if( theYOffset == null) return false;
		if( theCharName == null) return false;
		if( theSpeed == null) return false;
		if( theHealth == null) return false;
		if( theFaceplateTextColor == null) return false;
		if( theFaceplateBgColor == null) return false;
		if( theFaceplateImage == null) return false;
		
		if( theLeftStandAnim== null || theLeftStandAnim.length == 0) return false;
		
		if( theLeftWalkAnim== null || theLeftWalkAnim.length == 0) return false;
		
		if( theLeftAirAnim== null || theLeftAirAnim.length == 0) return false;
		
		if( theRightStandAnim== null || theRightStandAnim.length == 0) return false;
		
		if( theRightWalkAnim== null || theRightWalkAnim.length == 0) return false;
		
		if( theRightAirAnim== null || theRightAirAnim.length == 0) return false;
		
		if( theBulletAnim== null || theLeftWalkAnim.length == 0) return false;
		
		if( theAttack== null) return false;
		if( theSpread== null) return false;
		if( theMedic== null) return false;
		
		
		if( theBulletSpawnXOffset == null) return false;
		if( theBulletSpawnYOffset == null) return false;
		
		
		
		
		
		return true;
	}
	
	
	
	
	
	
	public String[] getFieldSummary() {
		
		ArrayList<String> returnValue = new ArrayList<String>();
		
		if(getNumericValue(this.statPanel.hitboxWidth) != null) {
			returnValue.add("HitBoxWidth:" + getNumericValue(this.statPanel.hitboxWidth));
		}
		if(getNumericValue(this.statPanel.hitboxHeight) != null) {
			returnValue.add("HitBoxHeight:" + getNumericValue(this.statPanel.hitboxHeight));
		}
		if(getNumericValue(this.statPanel.hitboxYOffset) != null) {
			returnValue.add("HitBoxYOffset:" + getNumericValue(this.statPanel.hitboxYOffset));
		}
		if(this.statPanel.name != null && this.statPanel.name.getText() != null) {
			returnValue.add("CharName:" + this.statPanel.name.getText().trim());
		}
		if(getNumericValue(this.statPanel.speed) != null ) {
			returnValue.add("Speed:" + getNumericValue(this.statPanel.speed));
		}
		if(getNumericValue(this.statPanel.health) != null ) {
			returnValue.add("Health:" + getNumericValue(this.statPanel.health));
		}
		returnValue.add("FaceplateTextColor:" + CustomAnimationPanel.convertColorToString(this.statPanel.textColorCanvas.getSingleColor()));
		returnValue.add("FaceplateBgColor:" + CustomAnimationPanel.convertColorToString(this.statPanel.backgroundColorCanvas.getSingleColor()));
		if(this.statPanel.facePreview.facePreviewPathname != null && this.statPanel.facePreview.image != null) {
			returnValue.add("FaceplateImage:" + this.statPanel.facePreview.facePreviewPathname);
		}
		
		if(this.leftAnimPanel.standAnimPanel.getImageArray() != null
				&& this.leftAnimPanel.standAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("LeftStandAnim:" + this.leftAnimPanel.standAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.leftAnimPanel.standAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		if(this.leftAnimPanel.walkAnimPanel.getImageArray() != null
				&& this.leftAnimPanel.walkAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("LeftWalkAnim:" + this.leftAnimPanel.walkAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.leftAnimPanel.walkAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		if(this.leftAnimPanel.airAnimPanel.getImageArray() != null
				&& this.leftAnimPanel.airAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("LeftAirAnim:" + this.leftAnimPanel.airAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.leftAnimPanel.airAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		
		
		if(this.rightAnimPanel.standAnimPanel.getImageArray() != null
				&& this.rightAnimPanel.standAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("RightStandAnim:" + this.rightAnimPanel.standAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.rightAnimPanel.standAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		if(this.rightAnimPanel.walkAnimPanel.getImageArray() != null
				&& this.rightAnimPanel.walkAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("RightWalkAnim:" + this.rightAnimPanel.walkAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.rightAnimPanel.walkAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		if(this.rightAnimPanel.airAnimPanel.getImageArray() != null
				&& this.rightAnimPanel.airAnimPanel.getImageArray().length > 0) {
			
			returnValue.add("RightAirAnim:" + this.rightAnimPanel.airAnimPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.rightAnimPanel.airAnimPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		
		
		if(this.bulletPanel.getImageArray() != null
				 && this.bulletPanel.getImageArray().length > 0) {
			returnValue.add("BulletAnim:" + this.bulletPanel.getImageArray().length);
			
			for(ListedCustomImage lci : this.bulletPanel.getImageArray()) {
				returnValue.add(lci.getFileName() + "*" + CustomAnimationPanel.convertColorToString(lci.getTransparentColor()));
			}
		}
		
		
		if(getNumericValue(this.bulletStatPanel.attack) != null) {
			returnValue.add("Attack:" + getNumericValue(this.bulletStatPanel.attack));
		}
		
		if(this.bulletStatPanel.spreadShots.isSelected()) {
			returnValue.add("Spread");
		} else {
			returnValue.add("NoSpread");
		}
		
		if(this.bulletStatPanel.medic.isSelected()) {
			returnValue.add("Medic");
		} else {
			returnValue.add("NoMedic");
		}
		
		
		if(getNumericValue(this.bulletStatPanel.bulletSpawnXOffset) != null) {
			returnValue.add("BulletSpawnXOffset:" + getNumericValue(this.bulletStatPanel.bulletSpawnXOffset));
		}
		
		if(getNumericValue(this.bulletStatPanel.bulletSpawnYOffset) != null) {
			returnValue.add("BulletSpawnYOffset:" + getNumericValue(this.bulletStatPanel.bulletSpawnYOffset));
		}
		
		
		
		return returnValue.toArray(new String[0]);
		
	}
	
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
	public String[] getContentArray() {
		return contentArray;
	}
	
}
